/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client;

import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.item.guns.util.IEntityTrackingGun;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gunsrpg", value={Dist.CLIENT})
public class GuidedProjectileTargetHandler {
    private static int selectedEntity = -1;
    private static int lockTimer;
    private static int updateTimer;
    private static boolean locked;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (event.phase == TickEvent.Phase.START || player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof IEntityTrackingGun) {
            IEntityTrackingGun gun = (IEntityTrackingGun)stack.func_77973_b();
            if (!gun.canBeGuided((PlayerEntity)player)) {
                selectedEntity = -1;
                return;
            }
            ++updateTimer;
            lockTimer = selectedEntity > -1 ? (lockTimer = lockTimer + 1) : 0;
            boolean wasLocked = locked;
            boolean bl = locked = lockTimer >= gun.getLockTime();
            if (!wasLocked && locked) {
                player.func_184185_a(ModSounds.RL_LOCKED1, 0.6f, 1.0f);
            }
            if (updateTimer >= 5) {
                updateTimer = 0;
                GuidedProjectileTargetHandler.updateTargetedEntity((PlayerEntity)player, gun);
            }
        }
    }

    public static int getSelectedEntity() {
        return locked ? selectedEntity : -1;
    }

    private static void updateTargetedEntity(PlayerEntity player, IEntityTrackingGun trackingGun) {
        boolean valid;
        Predicate<Entity> canTarget;
        AxisAlignedBB axisalignedbb;
        int range = trackingGun.getMaxRange();
        Vector3d position = player.func_174824_e(1.0f);
        Vector3d look = player.func_70040_Z();
        Vector3d targetedLocation = position.func_72441_c(look.field_72450_a * (double)range, look.field_72448_b * (double)range, look.field_72449_c * (double)range);
        EntityRayTraceResult result = GuidedProjectileTargetHandler.getEntityHitResult((Entity)player, position, targetedLocation, axisalignedbb = player.func_174813_aQ().func_216361_a(look.func_186678_a((double)range)).func_72314_b(1.0, 1.0, 1.0), canTarget = target -> target != player && target instanceof LivingEntity && player.func_70685_l(target), range * range);
        boolean bl = valid = result != null && result.func_216348_a() != null;
        if (valid) {
            Entity entity = GuidedProjectileTargetHandler.getActualEntity(result);
            int lastId = selectedEntity;
            selectedEntity = entity.func_145782_y();
            if (lastId != -1 && lastId != selectedEntity) {
                locked = false;
                lockTimer = 0;
            }
            String entityName = entity.func_200200_C_().getString();
            IFormattableTextComponent message = locked ? new TranslationTextComponent("text.rocket_lock.locked", new Object[]{entityName}).func_240699_a_(TextFormatting.RED) : new TranslationTextComponent("text.rocket_lock.locking", new Object[]{entityName}).func_240699_a_(TextFormatting.YELLOW);
            Minecraft.func_71410_x().field_71456_v.func_238450_a_(ChatType.GAME_INFO, (ITextComponent)message, Util.field_240973_b_);
        } else {
            selectedEntity = -1;
        }
    }

    private static Entity getActualEntity(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        PartEntity[] parts = entity.getParts();
        if (parts != null && parts.length > 0) {
            return parts[0];
        }
        return entity;
    }

    private static EntityRayTraceResult getEntityHitResult(Entity shooter, Vector3d vec1, Vector3d vec2, AxisAlignedBB aabb, Predicate<Entity> predicate, double range) {
        World world = shooter.field_70170_p;
        double d0 = range;
        Entity entity = null;
        Vector3d vector3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, aabb, predicate)) {
            Vector3d vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(3.0);
            Optional optional = axisalignedbb.func_216365_b(vec1, vec2);
            if (axisalignedbb.func_72318_a(vec1)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(vec1);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = vec1.func_72436_e(vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vector3d);
    }
}

